/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.gun;

import dev.toma.configuration.config.Configurable;
import dev.toma.gunsrpg.api.common.IWeaponConfig;
import dev.toma.gunsrpg.config.gun.SimpleWeaponConfiguration;
import dev.toma.gunsrpg.config.gun.WeaponConfiguration;

public final class WeaponConfig {
    @Configurable
    @Configurable.Comment(value={"Allows you to disable weapon durability loss while shooting"})
    public boolean disableWeaponDurability = false;
    @Configurable
    @Configurable.Synchronized
    @Configurable.DecimalRange(min=0.0, max=10.0)
    @Configurable.Comment(value={"Global weapon recoil multiplier"})
    @Configurable.Gui.NumberFormat(value="0.0##")
    public float globalWeaponRecoilMultiplier = 1.0f;
    @Configurable
    @Configurable.Synchronized
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Weapon recoil multiplier when crouching"})
    @Configurable.Gui.NumberFormat(value="0.0##")
    public float crouchWeaponRecoilMultiplier = 0.85f;
    @Configurable
    @Configurable.Comment(value={"M1911 Weapon configuration"})
    public IWeaponConfig m1911 = new WeaponConfiguration(4.0f, 280, 3, 0.006f, 0.09f);
    @Configurable
    @Configurable.Comment(value={"R45 weapon configuration"})
    public IWeaponConfig r45 = new WeaponConfiguration(7.0f, 320, 4, 0.008f, 0.12f);
    @Configurable
    @Configurable.Comment(value={"Desert Eagle weapon configuration"})
    public IWeaponConfig desertEagle = new WeaponConfiguration(8.0f, 330, 5, 0.007f, 0.1f);
    @Configurable
    @Configurable.Comment(value={"UMP weapon configuration"})
    public IWeaponConfig ump = new WeaponConfiguration(3.0f, 320, 5, 0.004f, 0.05f);
    @Configurable
    @Configurable.Comment(value={"Thompson weapon configuration"})
    public IWeaponConfig thompson = new WeaponConfiguration(5.0f, 320, 5, 0.005f, 0.05f);
    @Configurable
    @Configurable.Comment(value={"Vector weapon configuration"})
    public IWeaponConfig vector = new WeaponConfiguration(3.0f, 280, 3, 0.003f, 0.02f);
    @Configurable
    @Configurable.Comment(value={"Crossbow weapon configuration"})
    public IWeaponConfig crossbow = new WeaponConfiguration(10.0f, 32, 8, 0.015f, 0.14f);
    @Configurable
    @Configurable.Comment(value={"Chukonu weapon configuration"})
    public IWeaponConfig chukonu = new WeaponConfiguration(6.0f, 32, 5, 0.006f, 0.008f);
    @Configurable
    @Configurable.Comment(value={"S1897 weapon configuration"})
    public IWeaponConfig s1897 = new WeaponConfiguration(2.0f, 220, 1, 0.01f, 0.08f);
    @Configurable
    @Configurable.Comment(value={"S686 weapon configuration"})
    public IWeaponConfig s686 = new WeaponConfiguration(2.0f, 220, 1, 0.012f, 0.1f);
    @Configurable
    @Configurable.Comment(value={"S12k weapon configuration"})
    public IWeaponConfig s12k = new WeaponConfiguration(2.0f, 220, 1, 0.008f, 0.08f);
    @Configurable
    @Configurable.Comment(value={"AKM weapon configuration"})
    public IWeaponConfig akm = new WeaponConfiguration(6.0f, 330, 4, 0.003f, 0.04f);
    @Configurable
    @Configurable.Comment(value={"HK-416 weapon configuration"})
    public IWeaponConfig hk416 = new WeaponConfiguration(5.0f, 380, 6, 0.005f, 0.05f);
    @Configurable
    @Configurable.Comment(value={"AUG weapon configuration"})
    public IWeaponConfig aug = new WeaponConfiguration(5.0f, 380, 6, 0.005f, 0.04f);
    @Configurable
    @Configurable.Comment(value={"SKS weapon configuration"})
    public IWeaponConfig sks = new WeaponConfiguration(7.0f, 380, 6, 0.01f, 0.11f);
    @Configurable
    @Configurable.Comment(value={"VSS weapon configuration"})
    public IWeaponConfig vss = new WeaponConfiguration(6.0f, 140, 2, 0.007f, 0.06f);
    @Configurable
    @Configurable.Comment(value={"Mk-14 EBR weapon configuration"})
    public IWeaponConfig mk14 = new WeaponConfiguration(9.0f, 440, 7, 0.006f, 0.07f);
    @Configurable
    @Configurable.Comment(value={"Kar98k weapon configuration"})
    public IWeaponConfig kar98k = new WeaponConfiguration(14.0f, 440, 7, 0.025f, 0.12f);
    @Configurable
    @Configurable.Comment(value={"Winchester weapon configuration"})
    public IWeaponConfig winchester = new WeaponConfiguration(10.0f, 340, 5, 0.02f, 0.1f);
    @Configurable
    @Configurable.Comment(value={"AWM weapon configuration"})
    public IWeaponConfig awm = new WeaponConfiguration(18.0f, 480, 8, 0.018f, 0.09f);
    @Configurable
    @Configurable.Comment(value={"Grenade launcher weapon configuration"})
    public IWeaponConfig grenadeLauncher = new SimpleWeaponConfiguration(1.6f, 0.01f, 0.09f);
    @Configurable
    @Configurable.Comment(value={"Rocket launcher weapon configuration"})
    public IWeaponConfig rocketLauncher = new SimpleWeaponConfiguration(2.0f, 0.01f, 0.1f);
}

